"""Utensil holder."""
from typing import Optional

from mojo import Mojo
from mojo.elements import Geom, MujocoElement

from bigym.const import ASSETS_PATH
from bigym.envs.props.prop import Prop


CUTLERY_TRAY_MODEL_PATH = ASSETS_PATH / "props/cutlery_tray/cutlery_tray.xml"


class CutleryTray(Prop):
    """Cutlery tray."""

    def __init__(self, mojo: Mojo, parent: Optional[MujocoElement] = None):
        """Init."""
        super().__init__(
            mojo,
            CUTLERY_TRAY_MODEL_PATH,
            cache_colliders=True,
            cache_sites=True,
            parent=parent,
        )


DRAINER_MODEL_PATH = ASSETS_PATH / "props/dish_drainer/dish_drainer.xml"


class DishDrainer(Prop):
    """Dish Drainer."""

    def __init__(self, mojo: Mojo, parent: Optional[MujocoElement] = None):
        """Init."""
        super().__init__(
            mojo,
            DRAINER_MODEL_PATH,
            cache_colliders=True,
            cache_sites=True,
            parent=parent,
        )
        self.holders_left: list[Geom] = self.colliders[0:7]
        self.holders_right: list[Geom] = self.colliders[7:14]
